/* $Id: adjlist.h,v 1.14 2007/01/25 10:02:10 mcv21 Exp $*/
/*
 * This file is part of the library of graph analysis and disease
 * simulation functions submitted along with the thesis "Spacial Spread
 * of Farm Animal Diseases" for the degree of Doctor of Philosophy at the
 * University of Cambridge. 
 *
 * The library is Copyright (C) 2007 Matthew Vernon <matthew@debian.org>
 *
 * This library is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published
 * by the Free Software Foundation; either version 2 of the License,
 * or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program (as gpl.txt); if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA
 */

#ifndef ADJLIST_H
#define ADJLIST_H

struct adjl{
  int id; /*For application use*/
  int length; /*internal use*/
  int n; /*How many nodes in list?*/
  int *neighb; /*The neighbours*/
};

struct adjl *adjl_new(const int n);
/*return 0 if edge already existed, 1 otherwise*/
int adjl_add(struct adjl *l, int new);
/*0 if not a neighbour, 1 otherwise*/
int adjl_neighbour(const struct adjl *haystack, const int needle);
void adjl_remove(struct adjl *haystack,const int needle);
/*bi-directionalises every edge*/
struct adjl *adjl_symmetrise(const struct adjl *g, const int n);
/*returns an adjacency list with every edge reversed
 *this is equivalent to making l[i].neighb be the list of nodes
 *which send an edge to i
 */
struct adjl *adjl_reverse(const struct adjl *g, const int n);
#endif /*ADJLIST_H*/
