/*$Id: census.h,v 1.4 2007/01/25 10:02:10 mcv21 Exp $*/
/*
 * This file is part of the library of graph analysis and disease
 * simulation functions submitted along with the thesis "Spacial Spread
 * of Farm Animal Diseases" for the degree of Doctor of Philosophy at the
 * University of Cambridge. 
 *
 * The library is Copyright (C) 2007 Matthew Vernon <matthew@debian.org>
 *
 * This library is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published
 * by the Free Software Foundation; either version 2 of the License,
 * or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program (as gpl.txt); if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA
 */

#ifndef SOLARIS
#include <stdint.h>
#else
#include <inttypes.h>
#endif

#ifndef CENSUS_H
#define CENSUS_H

#define AB 0x0001
#define BA 0x0002
#define AC 0x0004
#define CA 0x0008
#define BC 0x0010
#define CB 0x0020
#define TTSIZE 0x0040

enum triad_types{
  T003,
  T012,
  T102,
  T021d,
  T021u,
  T021c,
  T111d,
  T111u,
  T030t,
  T030c,
  T201,
  T120d,
  T120u,
  T120c,
  T210,
  T300,
  TTYPES};
typedef uint64_t triad_count[TTYPES];

struct dyadcount_t{
  int64_t m; /*mutual dyads*/
  int64_t a; /*assymetric dyads*/
  int64_t n; /*null dyads*/
};
typedef struct dyadcount_t dyad_count;

extern int triad_table[TTSIZE];

#endif /*CENSUS_H*/
