/* $Id: dll.c,v 1.2 2007/01/25 10:02:10 mcv21 Exp $*/
/*
 * This file is part of the library of graph analysis and disease
 * simulation functions submitted along with the thesis "Spacial Spread
 * of Farm Animal Diseases" for the degree of Doctor of Philosophy at the
 * University of Cambridge. 
 *
 * The library is Copyright (C) 2007 Matthew Vernon <matthew@debian.org>
 *
 * This library is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published
 * by the Free Software Foundation; either version 2 of the License,
 * or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program (as gpl.txt); if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA
 */

#include <stdlib.h>

#include "gads.h"
#include "ferror.h"

struct dll *new_dll(void)
{
  struct dll *l;

  if(NULL==(l=malloc(sizeof(*l))))
    fatal_error("allocating dll pointer",NULL,1);

  l->top=NULL;
  l->bottom=NULL;

  return(l);
}

void dll_append(struct dll *l, const int x)
{
  struct dlln *n;

  if(NULL==(n=malloc(sizeof(*n))))
    fatal_error("allocating dll node",NULL,1);

  n->x=x;
  n->next=NULL;
  n->prev=NULL;

  if(l->bottom){
    l->bottom->next=n;
    n->prev=l->bottom;
    l->bottom=n;
  }
  else{
    l->top=n;
    l->bottom=n;
  }
}

void dll_remove(struct dll *l, struct dlln *n)
{
  if(NULL==l->top) return; /*list was empty*/

  if(NULL==n->prev) /*top of list*/
    l->top=n->next;
  if(NULL==n->next) /*bottom of list*/
    l->bottom=n->prev;

  if(n->next) n->next->prev=n->prev;
  if(n->prev) n->prev->next=n->next;

  free(n);
}
