/*$Id: ferror.c,v 1.7 2007/01/25 10:02:10 mcv21 Exp $*/
/*
 * This file is part of the library of graph analysis and disease
 * simulation functions submitted along with the thesis "Spacial Spread
 * of Farm Animal Diseases" for the degree of Doctor of Philosophy at the
 * University of Cambridge. 
 *
 * The library is Copyright (C) 2007 Matthew Vernon <matthew@debian.org>
 *
 * This library is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published
 * by the Free Software Foundation; either version 2 of the License,
 * or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program (as gpl.txt); if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA
 */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <errno.h>

#include "ferror.h"

void f_error(const char *message, const char *detail, const char *file, const int line, const int use_errno)
{
  int x=errno; /*otherwise our fprintf calls will clear it*/
  fprintf(stderr,"Fatal Error at %s:%d - %s\n",file,line,message);
  if(detail)fprintf(stderr,"Detail: %s\n",detail);
  if(use_errno)fprintf(stderr,"Errno: %s\n",strerror(x));
  exit(1);
}

void *x_realloc(void *ptr, size_t size, const char *file, const int line)
{
  void *val;

  if(0==size){
    free(ptr);
    return(NULL);
  }
  if(NULL==(val=realloc(ptr,size)))
    f_error("Realloc failed",NULL,file,line,1);
  return(val);
}

void *x_malloc(size_t n, const char *file, const int line)
{
  void *val;
  if(!(val=malloc(n))&&n)
    f_error("Malloc failed",NULL,file,line,1);
  return(val);
}

void *x_calloc(size_t count, size_t size, const char *file, 
	       const int line)
{
  void *val;
  if(!(val=calloc(count,size))&&count&&size)
    f_error("Calloc failed",NULL,file,line,1);
  return(val);
}
