/*$Id: ferror.h,v 1.7 2007/01/25 10:02:10 mcv21 Exp $*/
/*
 * This file is part of the library of graph analysis and disease
 * simulation functions submitted along with the thesis "Spacial Spread
 * of Farm Animal Diseases" for the degree of Doctor of Philosophy at the
 * University of Cambridge. 
 *
 * The library is Copyright (C) 2007 Matthew Vernon <matthew@debian.org>
 *
 * This library is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published
 * by the Free Software Foundation; either version 2 of the License,
 * or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program (as gpl.txt); if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA
 */


#include <stdlib.h>

#define fatal_error(message,detail,use_errno) f_error(message,detail,__FILE__,__LINE__,use_errno)

#define xrealloc(ptr,size) x_realloc(ptr,size,__FILE__,__LINE__)
#define xmalloc(size) x_malloc(size,__FILE__,__LINE__)
#define xcalloc(count,size) x_calloc(count,size,__FILE__,__LINE__)

#if __GNUC__
#define ferror_attribute(x) __attribute__(x)
#else
#define ferror_attribute(x)
#endif

void f_error(const char *message, const char *detail, const char *file, const int line, const int use_errno) ferror_attribute((noreturn));

void *x_realloc(void *ptr, size_t size, const char *file, const int line);
void *x_malloc(size_t n, const char *file, const int line);
void *x_calloc(size_t count, size_t size, const char *file, 
	       const int line);
