/* $Id: fifo.c,v 1.7 2007/01/25 10:02:10 mcv21 Exp $*/
/*
 * This file is part of the library of graph analysis and disease
 * simulation functions submitted along with the thesis "Spacial Spread
 * of Farm Animal Diseases" for the degree of Doctor of Philosophy at the
 * University of Cambridge. 
 *
 * The library is Copyright (C) 2007 Matthew Vernon <matthew@debian.org>
 *
 * This library is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published
 * by the Free Software Foundation; either version 2 of the License,
 * or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program (as gpl.txt); if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA
 */

#include <stdlib.h>

#include "ferror.h"
#include "gads.h"

/*Implementation of a simple FIFO queue*/

/*note that if n elements are needed, we want n+1 allocated 
 *for our queue
 */
struct fifo_q *fq_new_queue(const int n)
{
  struct fifo_q *q;

  if(NULL==(q=malloc(sizeof(*q)))){
    fatal_error("allocating queue pointer",NULL,1);
  }
  if(NULL==(q->queue=malloc((n+1)*sizeof(*(q->queue))))){
    fatal_error("allocating queue",NULL,1);
  }
  q->n=(n+1);
  q->head=q->tail=q->queue;
  return(q);
}

void fq_insert_node(struct fifo_q *q, const int x)
{
  if(q->head==(q->tail==q->queue+(q->n-1)?q->queue:q->tail+1))
    fatal_error("Over-flowed queue",NULL,0);
  *q->tail=x;
  q->tail=(q->tail==q->queue+(q->n-1))?
    q->queue:
    q->tail+1;
}

int fq_remove_node(struct fifo_q *q)
{
  int x;
  if(q->head==q->tail) return(-1);
  x=*q->head;
  q->head=(q->head==q->queue+(q->n-1))?
    q->queue:
    q->head+1;
  return(x);
}
