/*$Id: g_al.c,v 1.12 2007/01/25 10:02:10 mcv21 Exp $*/
/*
 * This file is part of the library of graph analysis and disease
 * simulation functions submitted along with the thesis "Spacial Spread
 * of Farm Animal Diseases" for the degree of Doctor of Philosophy at the
 * University of Cambridge. 
 *
 * The library is Copyright (C) 2007 Matthew Vernon <matthew@debian.org>
 *
 * This library is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published
 * by the Free Software Foundation; either version 2 of the License,
 * or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program (as gpl.txt); if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA
 */

#include "g_al.h"
#include "ferror.h"
#include "utils.h"

const struct gennetvtable vtable_for_adjlistnet=
  {
    G_ADJL,
    al_test,
    al_set,
    al_setval,
    al_unset,
    al_next,
    al_sort,
    al_free
  };

int al_test(const struct gennet *g, const int x, const int y)
{
  const struct adjlnet *l=(const struct adjlnet *)g;

  return(adjl_neighbour(&l->net[x],y));
}

int al_set(struct gennet *g, const int x, const int y)
{
  struct adjlnet *l=(struct adjlnet *)g;

  if(adjl_add(&l->net[x],y)){
    l->sorted=0;
    return(1);
  }
  else return(0);
}

int al_setval(struct gennet *g, const int x, const int y, const int val)
{
  fatal_error("weighted edges not supported by adjacency-list network",NULL,0);
}

void al_unset(struct gennet *g, const int x, const int y)
{
  struct adjlnet *l=(struct adjlnet *)g;

  adjl_remove(&l->net[x],y);
  l->sorted=0;
}

int al_next(const struct gennet *g, const int node, const int x)
{
  int a;
  const struct adjlnet *l=(const struct adjlnet *)g;
  
  /*This routine requires a sorted adjacency list*/
  if(1!=l->sorted)
    qsort(l->net[node].neighb,l->net[node].n,sizeof(int),int_cmp);

  for(a=0;a<l->net[node].n;a++)
    if(l->net[node].neighb[a]>x) return l->net[node].neighb[a];
  return(-1);
}

void al_sort(struct gennet *g)
{
  struct adjlnet *l=(struct adjlnet *)g;
  int a;

  if(1==l->sorted) return;

  for(a=0;a<l->n;a++)
    qsort(l->net[a].neighb,l->net[a].n,sizeof(int),int_cmp);
  l->sorted=1;
}

void al_free(struct gennet *g)
{
  struct adjlnet *l=(struct adjlnet *)g;
  int i;

  for(i=0;i<l->n;i++){
    if(l->net[i].neighb) free(l->net[i].neighb);
  }
  free(l->net);
  free(l);
}

struct gennet *al_convert(const struct gennet *g, const int n)
{
  int u,v;
  struct adjlnet *l;

  l=(struct adjlnet *)adjlist_create(n);
  for(u=0;u<n;u++)
    for(v=0;v<n;v++)
      if((u!=v)&&(g->vtable->test(g,u,v)))
	adjl_add(&l->net[u],v);
  l->sorted=1;
  
  return(&l->general);
}
 
void adjlstar_free(struct adjl *l,const int n)
{
  int i;
  for(i=0;i<n;i++)
    if(l[i].neighb) free(l[i].neighb);
  
  free(l);
}


