/*$Id: g_al.h,v 1.10 2007/01/25 10:02:10 mcv21 Exp $*/
/*
 * This file is part of the library of graph analysis and disease
 * simulation functions submitted along with the thesis "Spacial Spread
 * of Farm Animal Diseases" for the degree of Doctor of Philosophy at the
 * University of Cambridge. 
 *
 * The library is Copyright (C) 2007 Matthew Vernon <matthew@debian.org>
 *
 * This library is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published
 * by the Free Software Foundation; either version 2 of the License,
 * or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program (as gpl.txt); if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA
 */

#ifndef G_AL_H
#define G_AL_H

#include "gens.h"
#include "adjlist.h"

gtest_fn al_test;
gset_fn al_set;
gsetval_fn al_setval;
gunset_fn al_unset;
giter_fn al_next;
gsort_fn al_sort;
gfree_fn al_free;

extern const struct gennetvtable vtable_for_adjlistnet;

struct adjlnet{
  /*This must remain the first element!*/
  struct gennet general;
  int n;
  struct adjl *net;
  int sorted; /*Set this to 0 when modifying the network*/
};

/*convert any other type of network to an adjacency list
 *this conveniently leaves all the adjacency lists sorted
 */
struct gennet *al_convert(const struct gennet *g, const int n);

void adjlstar_free(struct adjl *l,const int n);

#endif /*G_AL_H*/
