/*$Id: g_bm.c,v 1.8 2007/01/25 10:02:10 mcv21 Exp $*/
/*
 * This file is part of the library of graph analysis and disease
 * simulation functions submitted along with the thesis "Spacial Spread
 * of Farm Animal Diseases" for the degree of Doctor of Philosophy at the
 * University of Cambridge. 
 *
 * The library is Copyright (C) 2007 Matthew Vernon <matthew@debian.org>
 *
 * This library is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published
 * by the Free Software Foundation; either version 2 of the License,
 * or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program (as gpl.txt); if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA
 */

#include "g_bm.h"
#include "ferror.h"

const struct gennetvtable vtable_for_bitmatrix=
  {
    G_BITM,
    bm_test,
    bm_set,
    bm_setval,
    bm_unset,
    bm_next,
    bm_sort,
    bm_free
  };

int bm_test(const struct gennet *g, const int x, const int y)
{
  const struct bitmatrix *b=(const struct bitmatrix *)g;

  return BM_TEST(b->net,x,y);
}

int bm_set(struct gennet *g, const int x, const int y)
{
  const struct bitmatrix *b=(const struct bitmatrix *)g;
  
  if (BM_TEST(b->net,x,y)) return 0;
  BM_SET(b->net,x,y);
  return 1;
}

int bm_setval(struct gennet *g, const int x, const int y, const int val)
{
  fatal_error("Edge weights not supported by the bitfield network type",NULL,0);
}

void bm_unset(struct gennet *g, const int x, const int y)
{
  const struct bitmatrix *b=(const struct bitmatrix *)g;
  BM_UNSET(b->net,x,y);
}

int bm_next(const struct gennet *g, const int node, const int x)
{
  int a;
  const struct bitmatrix *b=(const struct bitmatrix *)g;
  
  for(a=x+1;a<b->n;a++)
    if(BM_TEST(b->net,node,x)) return x;
  return -1;
}

void bm_sort(struct gennet *g)
{
}

void bm_free(struct gennet *g)
{
  struct bitmatrix *b=(struct bitmatrix *)g;

  free(b->net[0]);
  free(b->net);
  free(b);
}
