/*$Id: g_bm.h,v 1.7 2007/01/25 10:02:10 mcv21 Exp $*/
/*
 * This file is part of the library of graph analysis and disease
 * simulation functions submitted along with the thesis "Spacial Spread
 * of Farm Animal Diseases" for the degree of Doctor of Philosophy at the
 * University of Cambridge. 
 *
 * The library is Copyright (C) 2007 Matthew Vernon <matthew@debian.org>
 *
 * This library is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published
 * by the Free Software Foundation; either version 2 of the License,
 * or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program (as gpl.txt); if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA
 */

#ifndef G_BM_H
#define G_BM_H

#include <limits.h>
#include <stdlib.h>

#include "gens.h"

#if CHAR_BIT !=8
#warning "bitmatrix code may run badly on this system!"
#endif

#define BM_BYTE(a) ((a)/CHAR_BIT)
#define BM_BIT(a) (1 << ((a) % CHAR_BIT))
/*is bit x of a set?*/
#define BM_TEST(m,a,x) (m[(a)][BM_BYTE(x)] & BM_BIT(x))
/*set bit x of a*/
#define BM_SET(m,a,x) (m[(a)][BM_BYTE(x)] |= BM_BIT(x))
/*unset bit x of a*/
#define BM_UNSET(m,a,x) (m[(a)][BM_BYTE(x)] &= ~BM_BIT(x))

#define BM_LEN(a) ((a/CHAR_BIT)+(a%CHAR_BIT?1:0))

gtest_fn bm_test;
gset_fn bm_set;
gsetval_fn bm_setval;
gunset_fn bm_unset;
giter_fn bm_next;
gsort_fn bm_sort;
gfree_fn bm_free;

extern const struct gennetvtable vtable_for_bitmatrix;

struct bitmatrix{
  /*This must remain the first element!*/
  struct gennet general;
  int n;
  unsigned char **net;
};

#endif /*G_BM_H*/
