/* $Id: g_im.c,v 1.7 2007/01/25 10:02:10 mcv21 Exp $*/
/*
 * This file is part of the library of graph analysis and disease
 * simulation functions submitted along with the thesis "Spacial Spread
 * of Farm Animal Diseases" for the degree of Doctor of Philosophy at the
 * University of Cambridge. 
 *
 * The library is Copyright (C) 2007 Matthew Vernon <matthew@debian.org>
 *
 * This library is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published
 * by the Free Software Foundation; either version 2 of the License,
 * or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program (as gpl.txt); if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA
 */

#include "g_im.h"

const struct gennetvtable vtable_for_intmatrix=
  {
    G_INTM,
    im_test,
    im_set,
    im_setval,
    im_unset,
    im_next,
    im_sort,
    im_free
  };

int im_test(const struct gennet *g, const int x, const int y)
{
  const struct intmatrix *m=(const struct intmatrix *)g;

  return(m->net[x][y]);
}

int im_set(struct gennet *g, const int x, const int y)
{
  const struct intmatrix *m=(const struct intmatrix *)g;

  if(m->net[x][y]) return 0;
  m->net[x][y]=1;
  return 1;
}

int im_setval(struct gennet *g, const int x, const int y,
	      const int val)
{
  const struct intmatrix *m=(const struct intmatrix *)g;

  if(m->net[x][y]) return 0;
  m->net[x][y]=val;
  return 1;
}


void im_unset(struct gennet *g, const int x, const int y)
{
  const struct intmatrix *m=(const struct intmatrix *)g;
  m->net[x][y]=0;
}

int im_next(const struct gennet *g, const int node, const int x)
{
  int a;
  const struct intmatrix *m=(const struct intmatrix *)g;
  
  for(a=x+1;a<m->n;a++)
    if(m->net[node][x]) return x;
  return -1;
}

void im_sort(struct gennet *g)
{
}

void im_free(struct gennet *g)
{
  struct intmatrix *m=(struct intmatrix *)g;

  free(m->net[0]);
  free(m->net);
  free(m);
}
