/* $Id: g_special.c,v 1.2 2007/01/25 10:02:10 mcv21 Exp $*/
/*
 * This file is part of the library of graph analysis and disease
 * simulation functions submitted along with the thesis "Spacial Spread
 * of Farm Animal Diseases" for the degree of Doctor of Philosophy at the
 * University of Cambridge. 
 *
 * The library is Copyright (C) 2007 Matthew Vernon <matthew@debian.org>
 *
 * This library is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published
 * by the Free Software Foundation; either version 2 of the License,
 * or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program (as gpl.txt); if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA
 */

#include "ferror.h"
#include "g_special.h"

const struct gennetvtable vtable_for_fullgraph=
  {
    G_FULL,
    f_test,
    f_set,
    f_setval,
    f_unset,
    f_next,
    f_sort,
    f_free
  };

const struct gennetvtable vtable_for_nullgraph=
  {
    G_NULL,
    n_test,
    n_set,
    n_setval,
    n_unset,
    n_next,
    n_sort,
    n_free
  };
    
int f_test(const struct gennet *g, const int x, const int y)
{
  return 1;
}

int n_test(const struct gennet *g, const int x, const int y)
{
  return 0;
}

int f_set(struct gennet *g, const int x, const int y)
{
  return 0;
}

int n_set(struct gennet *g, const int x, const int y)
{
  fatal_error("Setting values not possible in null graph",NULL,0);
}

int f_setval(struct gennet *g, const int x, const int y, const int val)
{
  fatal_error("Setting link values not possible in full graph",NULL,0);
}

int n_setval(struct gennet *g, const int x, const int y, const int val)
{
  fatal_error("Setting link values not possible in null graph",NULL,0);
}
  
void f_unset(struct gennet *g, const int x, const int y)
{
  fatal_error("Unsetting edges not supported by full-graph type",NULL,0);
}

void n_unset(struct gennet *g, const int x, const int y)
{
  fatal_error("Unsetting edges not supported by null graph",NULL,0);
}

int f_next(const struct gennet *g, const int node, const int x)
{
  int new;
  const struct fullgraph *f=(const struct fullgraph *)g;
  /*return the next node that isn't a self-loop, until we run out of nodes*/
  new=x+1==node? x+2 : x+1;
  return new<f->n ? new : -1;
}

int n_next(const struct gennet *g, const int node, const int x)
{
  return -1;
}

void f_sort(struct gennet *g){};
void n_sort(struct gennet *g){};

void f_free(struct gennet *g)
{
  free(g);
}

void n_free(struct gennet *g)
{
  free(g);
}
