/* $Id: g_special.h,v 1.2 2007/01/25 10:02:10 mcv21 Exp $*/
/*
 * This file is part of the library of graph analysis and disease
 * simulation functions submitted along with the thesis "Spacial Spread
 * of Farm Animal Diseases" for the degree of Doctor of Philosophy at the
 * University of Cambridge. 
 *
 * The library is Copyright (C) 2007 Matthew Vernon <matthew@debian.org>
 *
 * This library is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published
 * by the Free Software Foundation; either version 2 of the License,
 * or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program (as gpl.txt); if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA
 */

#ifndef G_SPECIAL_H
#define G_SPECIAL_H

#include "gens.h"

gtest_fn f_test, n_test;
gset_fn f_set, n_set;
gsetval_fn f_setval, n_setval;
gunset_fn f_unset, n_unset;
giter_fn f_next, n_next;
gsort_fn f_sort, n_sort;
gfree_fn f_free, n_free;

extern const struct gennetvtable vtable_for_fullgraph;
extern const struct gennetvtable vtable_for_nullgraph;

struct fullgraph{
  /*This must remain the first element!*/
  struct gennet general;
  int n;
};

#endif /*G_SPECIAL_H*/
