/* $Id: gads.h,v 1.13 2007/01/25 10:02:10 mcv21 Exp $ */
/*
 * This file is part of the library of graph analysis and disease
 * simulation functions submitted along with the thesis "Spacial Spread
 * of Farm Animal Diseases" for the degree of Doctor of Philosophy at the
 * University of Cambridge. 
 *
 * The library is Copyright (C) 2007 Matthew Vernon <matthew@debian.org>
 *
 * This library is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published
 * by the Free Software Foundation; either version 2 of the License,
 * or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program (as gpl.txt); if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA
 */

#ifndef GADS_H
#define GADS_H

struct fh_node{
  struct fh_node *left;
  struct fh_node *right;
  struct fh_node *parent;
  struct fh_node *child;
  int degree;
  int mark;
  int key;
  int id;
};

struct fh_heap{
  struct fh_node *min;
  int n;
};

struct fifo_q{
  int *queue;
  int *head;
  int *tail;
  int n;
};

struct stack{
  int *s;
  int *top;
  int n;
};

struct sll{
  struct slln *top;
  struct slln *bottom;
};

struct slln{
  int x;
  struct slln *next;
};

struct dll{
  struct dlln *top;
  struct dlln *bottom;
};

struct dlln{
  int x;
  struct dlln *prev;
  struct dlln *next;
};

struct fh_node *fh_new_node(void);
struct fh_heap *fh_new_heap(void);
void fh_insert_node(struct fh_node *new, struct fh_heap *heap);
struct fh_node *fh_extract_min(struct fh_heap *heap);
void fh_decrease_key(struct fh_node *node, struct fh_heap *heap, 
		     const int val);

struct fifo_q *fq_new_queue(const int n);
void fq_insert_node(struct fifo_q *q, const int x);
/*return -1 if fifo empty*/
int fq_remove_node(struct fifo_q *q);

struct stack *new_stack(const int n);
void push(struct stack *s, const int x);
/*returns -1 if stack empty*/
int pop(struct stack *s);

struct sll *new_sll(void);
void sll_append(struct sll *l, const int x);
/*returns -1 if list empty*/
int sll_remove(struct sll *l);
/*You can also use sll to implement a variable-length stack*/
int sll_pop(struct sll *l); /*just calls sll_remove*/
void sll_push(struct sll *l, const int x);

struct dll *new_dll(void);
void dll_append(struct dll *l, const int x);
void dll_remove(struct dll *l, struct dlln *n);

/*a and b should be sorted, lowest first; if reslen is non-NULL, then
 *it is set tothe length of the allocated return array 
 */
int *int_union(int *a, const int lena, int *b, const int lenb, int *reslen);
/*a and b should be sorted, lowest first
 *if max>=0, then only values <max will be considered
 */
int *int_and(int *a, const int lena, int *b, const int lenb, 
	     int max, int *reslen);
/*a and b should be sorted, lowest first
 *if max>=0, then only values <max will be considered
 */
int *int_xor(int *a, const int lena, int *b, const int lenb, 
	     int max, int *reslen);
/*returns the number of integers in a <max*/
int int_lt(int *a, const int lena,int max);

#endif /*GADS_H*/
