/* $Id: gens.h,v 1.13 2007/01/25 10:02:10 mcv21 Exp $ */
/*
 * This file is part of the library of graph analysis and disease
 * simulation functions submitted along with the thesis "Spacial Spread
 * of Farm Animal Diseases" for the degree of Doctor of Philosophy at the
 * University of Cambridge. 
 *
 * The library is Copyright (C) 2007 Matthew Vernon <matthew@debian.org>
 *
 * This library is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published
 * by the Free Software Foundation; either version 2 of the License,
 * or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program (as gpl.txt); if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA
 */

#ifndef GENS_H
#define GENS_H

struct gennetvtable;

struct gennet{
  const struct gennetvtable *vtable;
};

/*return non-zero if there is an edge x->y*/
typedef int gtest_fn(const struct gennet *g, const int x, const int y);
  /*return 0 if the edge existed, 1 otherwise*/
typedef int gset_fn(struct gennet *g,const int x, const int y);
typedef int gsetval_fn(struct gennet *g,const int x, const int y, 
		       const int val);
typedef void gunset_fn(struct gennet *g, const int x, const int y);
/*return -1 when no more neighbours*/
typedef int giter_fn(const struct gennet *g, const int node, const int x);
/*Sorts adjacency lists, NO-OP on int/bit-matrix structures*/
typedef void gsort_fn(struct gennet *g);
/*Use this function to free a struct gennet properly*/
typedef void gfree_fn(struct gennet *g);

typedef enum { G_BITM,G_INTM,G_ADJL,G_FULL,G_NULL,G_ANY } net_desired_t;

struct gennetvtable{
  const net_desired_t type;
  gtest_fn *test;
  gset_fn *set;
  gsetval_fn *setval;
  gunset_fn *unset;
  giter_fn *next_neighb;
  gsort_fn *sort;
  gfree_fn *free;
};

struct degdist{
  int n; /*number of nodes*/
  int *in; /*indegrees*/
  int *out; /*outdegrees*/
};


struct gennet *bitmatrix_create(const int n);
struct gennet *intmatrix_create(const int n);
struct gennet *adjlist_create(const int n);
struct gennet *fullgraph_create(const int n);
struct gennet *nullgraph_create(const int n);


/*Don't call this with G_ANY*/
struct gennet *type_create(const int n, const net_desired_t type);


#endif /*GENS_H*/
