/*$Id: utils.c,v 1.9 2007/01/25 10:02:10 mcv21 Exp $*/
/*
 * This file is part of the library of graph analysis and disease
 * simulation functions submitted along with the thesis "Spacial Spread
 * of Farm Animal Diseases" for the degree of Doctor of Philosophy at the
 * University of Cambridge. 
 *
 * The library is Copyright (C) 2007 Matthew Vernon <matthew@debian.org>
 *
 * This library is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published
 * by the Free Software Foundation; either version 2 of the License,
 * or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program (as gpl.txt); if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA
 */

#include <stdlib.h>
#include "gads.h"
#include "ferror.h"

/*a and b should be sorted, lowest first */
int *int_union(int *a, const int lena, int *b, const int lenb, int *reslen)
{
  int *x=a, *y=b;
  int *new;
  int i, apos=0, bpos=0;

  if(NULL==(new=malloc((lena+lenb)*sizeof(int))))
    fatal_error("Unable to allocate new integer array",NULL,1);
  
  for(i=0;i<(lena+lenb);i++)
    { /*first see if either array is finished with*/
      if(apos==lena){
	if(bpos==lenb) break;
	else {new[i]=*y; y++; bpos++;}
      }else if(bpos==lenb)
	{new[i]=*x; x++; apos++;}
      else{
	/*increment the lower array, or both if values are equal*/
	if(*x<*y) {new[i]=*x; x++; apos++;}
	else if (*x>*y) {new[i]=*y; y++; bpos++;}
	else {new[i]=*x; x++; y++; apos++; bpos++;}
      }
    }

  new=xrealloc(new,i*sizeof(int));
  if(reslen) *reslen=i;
  return(new);
}

/*a and b should be sorted, lowest first
 *if max>=0, then only values <max will be considered
 */
int *int_and(int *a, const int lena, int *b, const int lenb, 
	     int max, int *reslen)
{
  int *x=a, *y=b;
  int *new;
  int i, apos=0, bpos=0;

  if(NULL==(new=malloc((lena>lenb?lena:lenb)*sizeof(int))))
    fatal_error("Unable to allocate new integer arragy",NULL,1);

  i=0;
  for(;;)
    { /*If either array is finished OR max>0 and x or y !<max, then done*/
      if((apos==lena)||(bpos==lenb)||
	 ((max>=0)&&((*x>=max)||(*y>=max)))) break;
      /*if either array is lower, increment that*/
      if(*x<*y) {x++; apos++;}
      else if(*x>*y) {y++; bpos++;}
      /*Otherwise, they're equal, so take that value, and increment
	both arrays, and the subscript in the new array
      */
      else {new[i]=*x; x++; y++; apos++; bpos++; i++;}
    }
  new=xrealloc(new,i*sizeof(int));
  if(reslen) *reslen=i;
  return(new);
}

static int *int_trimcopy(int *a, const int lena, int *new, int max)
{
  int i;
  for(i=0;i<lena;i++) new[i]=a[i];
  i=int_lt(new,i,max);
  new=xrealloc(new,i*sizeof(int));
  return(new);
}

/*a and b should be sorted, lowest first
 *if max>=0, then only values <max will be considered
 */
int *int_xor(int *a, const int lena, int *b, const int lenb, 
	     int max, int *reslen)
{
  int *x=a,*y=b;
  int *new;
  int i, apos=0, bpos=0;

  if(NULL==(new=malloc((lena+lenb)*sizeof(int))))
    fatal_error("Unable to allocate new integer array",NULL,1);

  /*Deal with one list being empty*/
  if(0==lenb){
    if(reslen) *reslen=int_lt(a,lena,max);
    return(int_trimcopy(a,lena,new,max));
  }
  if(0==lena){
    if(reslen) *reslen=int_lt(b,lenb,max);
    return(int_trimcopy(b,lenb,new,max));
  }

  for(i=0;i<(lena+lenb);i++)
    { /*first see if either array is finished with
       *if so, then work through the other until
       *it is finished (continuing to check it's not equal)
       */
      if(apos==lena){
	x=&a[lena-1];
	if(bpos==lenb) break;
	else if(*y!=*x) {new[i]=*y; y++; bpos++;}
	else {i--; y++; bpos++;}
      }else if(bpos==lenb){
	y=&b[lenb-1];
	if(*x!=*y) {new[i]=*x; x++; apos++;}
	else {i--; x++; apos++;}
      }
      else{
	/*increment the lower array*/
	if(*x<*y) {new[i]=*x; x++; apos++;}
	else if (*x>*y) {new[i]=*y; y++; bpos++;}
	/*If both equal, decrement i and increment each array*/
	else {i--; x++; y++; apos++; bpos++;}
      }
    }
  /*now worry about max - keeps the above simpler*/
  if(max>=0)
    i=int_lt(new,i,max);
  new=xrealloc(new,i*sizeof(int));
  if(reslen) *reslen=i;
  return(new);
}

/*returns the number of integers in a <max*/
int int_lt(int *a, const int lena,int max)
{
  int i;
  for(i=0;i<lena;i++)
    if(a[i]>=max) break;
  return(i);
}
