/* $Id: sll.c,v 1.5 2007/01/25 10:02:10 mcv21 Exp $*/
/*
 * This file is part of the library of graph analysis and disease
 * simulation functions submitted along with the thesis "Spacial Spread
 * of Farm Animal Diseases" for the degree of Doctor of Philosophy at the
 * University of Cambridge. 
 *
 * The library is Copyright (C) 2007 Matthew Vernon <matthew@debian.org>
 *
 * This library is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published
 * by the Free Software Foundation; either version 2 of the License,
 * or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program (as gpl.txt); if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA
 */

#include <stdlib.h>

#include "gads.h"
#include "ferror.h"

struct sll *new_sll(void)
{
  struct sll *l;

  if(NULL==(l=malloc(sizeof(*l))))
    fatal_error("allocating sll pointer",NULL,1);

  l->top=NULL;
  l->bottom=NULL;

  return(l);
}

int sll_pop(struct sll *l)
{
  return(sll_remove(l));
}

void sll_push(struct sll *l, const int x)
{
  struct slln *n;

  if(NULL==(n=malloc(sizeof(*n))))
    fatal_error("allocating sll node",NULL,1);

  n->x=x;
  if(l->top){
    n->next=l->top;
  }
  else{
    l->bottom=n;
    n->next=NULL;
  }
  l->top=n;
} 

void sll_append(struct sll *l, const int x)
{
  struct slln *n;

  if(NULL==(n=malloc(sizeof(*n))))
    fatal_error("allocating sll node",NULL,1);

  n->x=x;
  n->next=NULL;

  if(l->bottom){
    l->bottom->next=n;
    l->bottom=n;
  }
  else{
    l->top=n;
    l->bottom=n;
  }
}

int sll_remove(struct sll *l)
{
  int x;
  struct slln *n;
  if(NULL==l->top) return(-1); /*list was empty*/

  n=l->top;
  x=n->x;
  l->top=n->next; /*if n->next=NULL, then sll is empty*/
  if(NULL==l->top) l->bottom=NULL;
  free(n);
  return(x);
}
