/* $Id: stack.c,v 1.8 2007/01/25 10:02:10 mcv21 Exp $ */
/*
 * This file is part of the library of graph analysis and disease
 * simulation functions submitted along with the thesis "Spacial Spread
 * of Farm Animal Diseases" for the degree of Doctor of Philosophy at the
 * University of Cambridge. 
 *
 * The library is Copyright (C) 2007 Matthew Vernon <matthew@debian.org>
 *
 * This library is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published
 * by the Free Software Foundation; either version 2 of the License,
 * or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program (as gpl.txt); if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA
 */

#include <stdlib.h>

#include "gads.h"
#include "ferror.h"

struct stack *new_stack(const int n)
{
  struct stack *s;

  if(NULL==(s=malloc(sizeof(*s))))
    fatal_error("allocating stack pointer",NULL,1);
  if(NULL==(s->s=calloc(n, sizeof(*s->s))))
    fatal_error("allocating stack",NULL,1);
  s->n=n;
  s->top=s->s;
  return(s);
}

/*put something in s->top, and move s->top along
 *(since empty stack has s->top pointing at 0)
 */
void push (struct stack *s, const int x)
{
  if(s->top-s->s >= (s->n))
    fatal_error("Stack overflow",NULL,0);
  *s->top=x;
  s->top++;
}

/*Decrement s->top first, since s->top
 *always points beyond our current point
 *return -1 if stack empty*/
int pop (struct stack *s)
{
  int x;
  if(s->top==s->s) return(-1);
  s->top--;
  x=*s->top;
  return(x);
}
